function saf
% SAF
% 
% Show all figures:
% Brings all figures to front of screen, and arranges them on the screen
% 
% Modified after:
% http://www.mathworks.com/support/solutions/en/data/1-1USVE3/index.html?pr
% oduct=ML&solution=1-1USVE3
% 
% Created by Yannick Kremer 2010
% University of Strathclyde
% Glasgow
% mail@ykremer.com

all_figure_handles = findall(0, 'type', 'figure');

figcount = length(all_figure_handles);

for i = 1: figcount,
    outerpos( i, : ) = get( all_figure_handles(i) ,'OuterPosition');
end
  
screensize = get(0,'ScreenSize');

if figcount > 4,
    outerpos( :, 1) = (linspace( 100, screensize(3)-outerpos(2,end)-100, figcount ))';
    outerpos( :, 2) = round(  screensize(4) /2);
else
    if figcount>0, outerpos(1, 1:2) = [ round(screensize(3)/2) - outerpos(1,3),  screensize(4) - 20 - outerpos(1, 4)]; end
    if figcount>1, outerpos(2, 1:2) = [ round(screensize(3)/2) ,  screensize(4) - 20 - outerpos(1, 4)]; end
    if figcount>2, outerpos(3, 1:2) = [ round(screensize(3)/2) - outerpos(3,3),  screensize(4) - 20 - outerpos(1, 4)- outerpos(3, 4)]; end
    if figcount>3, outerpos(4, 1:2) = [ round(screensize(3)/2) ,  screensize(4) - 20 - outerpos(1, 4) - outerpos(3, 4)]; end
end

for i = 1: figcount,
    figure( all_figure_handles( i ))
    set(    all_figure_handles( i ),'OuterPosition', outerpos( i, : )) ;
end
% clear all_figure_handles icount